<?
# Module: Auth
# count-auth.inc Copyright (C) 2002 Sandino Araico Snchez
/* --LICENSE IN US ENGLISH----------------------------------------------------- 
 * "THE BEER-WARE LICENSE" (Revision 42-sandino-3): 
 * Sandino Araico Snchez <sandino@sandino.net> wrote this file. 
 * As long as you retain this notice you can do whatever you want with this 
 * software. If we meet some day, and you think this stuff is worth it, you can 
 * buy me a beer in return. 
 * Sandino Araico Snchez 
 * --END LICENSE---------------------------------------------------------------
 * --LICENCIA EN ESPAOL MEXICANO----------------------------------------------
 * "LA LICENCIA BEER-WARE" (traduccin al espaol de la revisin 42-sandino-3):
 * Sandino Araico Snchez <sandino@sandino.net> escribi ste archivo.
 * Siempre y cuando usted retenga ste aviso (en espaol y en ingls) usted
 * puede hacer cualquier cosa con ste software. Si algn da nos encontramos y 
 * usted piensa que ste software vale la pena, usted puede invitarme una 
 * cerveza en recompensa.
 * Sandino Araico Snchez
 * --FIN DE LICENCIA-----------------------------------------------------------
 */
 
# Changelog: 

# 2002-01-05 Sandino Araico Snchez - Limited times access
# 2002-01-11 Sandino Araico Snchez - auth_count_with_exceptions()

if(!defined("__HOPP_COUT_AUTH"))
{
define ("__HOPP_COUT_AUTH",1);
#---------------------------------------------------------------------
include __HOPP_INCLUDE_PATH.'auth/basic-auth.inc';
#---------------------------------------------------------------------
if(!defined('__HOPP_AUTH_COUNT_DEFAULT_MAX'))
	define('__HOPP_AUTH_COUNT_DEFAULT_MAX',3);
#---------------------------------------------------------------------

function auth_count($doc, $defid=0)
{
	if(get_auth_count($doc, $defid))
	{
		echo __HOPP_AUTH_BASIC_REALM.': '.__HOPP_AUTH_BASIC_REALM_UNAUTHORIZED."\n";
		exit;
		//auth_basic_headers_send();
	}
}

function auth_count_with_exceptions($doc, $exceptions, $defid=0)
{
	global $PHP_AUTH_USER;
	
	$id=hopp_db_connected($defid);

	$count=get_auth_count($doc, $id);

	if($count)
	{
		$user=str_replace("'",'',$PHP_AUTH_USER);
		$item=str_replace("'",'',$doc);
		$md5item=md5($doc);
		if((!is_array($exceptions))||(!in_array($user, $exceptions)))
		{
			echo __HOPP_AUTH_BASIC_REALM.': '.__HOPP_AUTH_BASIC_REALM_UNAUTHORIZED."\n";
			exit;
			//auth_basic_headers_send();
		}
		increment_auth_count($user,$md5item,$id);
	}
}

function get_auth_count($doc, $defid=0)
{
	global $PHP_AUTH_USER;
	
	$user=str_replace("'",'',$PHP_AUTH_USER);
	$item=str_replace("'",'',$doc);
	$md5item=md5($doc);
	
	$id=hopp_db_connected($defid);
	hopp_db_start_transaction($id);
	$sql="select h_auth_count_access, h_auth_count_max from h_auth_count where h_auth_count_user='$user' and h_auth_count_item_md5='$md5item'";
	s_log("sql: $sql");
	$result=hopp_db_get_single_row_array_result($id, $sql);
	if(is_array($result))
	{
		$curr=$result['h_auth_count_access'];
		$max=$result['h_auth_count_max'];
		s_log("curr: $curr\tmax: $max");
		if($curr >= $max)
		{
			hopp_db_rollback_transaction($id);
			return 1;
		}	
	}
	else
	{
		$sql="insert into h_auth_count (h_auth_count_user,h_auth_count_item,h_auth_count_item_md5,h_auth_count_access,h_auth_count_max) values ('$user','$item','$md5item',0,".__HOPP_AUTH_COUNT_DEFAULT_MAX.")";
		s_log("sql: $sql");
		hopp_db_exec($id, $sql);
	}
	increment_auth_count($user,$md5item,$id);
	hopp_db_end_transaction($id);
}

function increment_auth_count($user,$md5item,$id)
{
	$sql="update h_auth_count set h_auth_count_access=h_auth_count_access+1 where h_auth_count_user='$user' and h_auth_count_item_md5='$md5item'";
	s_log("sql: $sql");
	hopp_db_exec($id, $sql);
}

#---------------------------------------------------------------------
} //__HOPP_COUT_AUTH

?>
