<?
# Module: cache
# cache.inc Copyright (C) 2001 Sandino Araico Snchez
/* --LICENSE IN US ENGLISH----------------------------------------------------- 
 * "THE BEER-WARE LICENSE" (Revision 42-sandino-3): 
 * Sandino Araico Snchez <sandino@sandino.net> wrote this file. 
 * As long as you retain this notice you can do whatever you want with this 
 * software. If we meet some day, and you think this stuff is worth it, you can 
 * buy me a beer in return. 
 * Sandino Araico Snchez 
 * --LICENCIA EN ESPAOL MEXICANO----------------------------------------------
 * "LA LICENCIA BEER-WARE" (traduccin al espaol de la revisin 42-sandino-3):
 * Sandino Araico Snchez <sandino@sandino.net> escribi ste archivo.
 * Siempre y cuando usted retenga ste aviso (en espaol y en ingls) usted
 * puede hacer cualquier cosa con ste software. Si algn da nos encontramos y 
 * usted piensa que ste software vale la pena, usted puede invitarme una 
 * cerveza en recompensa.
 * Sandino Araico Snchez
 * --FIN DE LICENCIA-----------------------------------------------------------
 */
 
# Changelog: 
# 2001-02-18 Sandino Araico Snchez - Cache de documentos originales
# 2001-03-12 Sandino Araico Snchez - Optimizaciones en el chequeo de directorios
# 2001-03-13 Sandino Araico Snchez - Cache de documentos procesados
# 2001-03-16 Sandino Araico Snchez - Librera autnoma hopp
# 2001-03-19 Sandino Araico Snchez - Workaround: $__APP_INCLUDE_PATH_, compatibilidad con PHP3
# 2001-09-18 Sandino Araico Snchez - Cambio de nombre, inclusin en Hopp

if(!defined("__HOPP_BASIC_CACHE_"))
{
	define("__HOPP_BASIC_CACHE_",1);
//--------------------------------------------------------------------
include __HOPP_INCLUDE_PATH."s.inc";
//--------------------------------------------------------------------

function hopp_put_doc_array_into_cache($host, $url, $array)
{
	hopp_put_remote_doc_array_into_cache($host, $url, $array);
}

function hopp_put_remote_doc_array_into_cache($host, $url, $array)
{
	$file_name=hopp_get_file_name_from_url($host, $url);
	hopp_put_generic_array_into_cache($file_name.".doc", $array);
	hopp_put_generic_array_into_cache($file_name.".md5", $array["DOC_MD5"]);
}

function hopp_put_local_doc_array_into_cache($string, $doc)
{
	$file_name=hopp_get_file_name_from_string($string).".doc";
	hopp_put_generic_array_into_cache($file_name, $doc, 1, 0);
}

function hopp_put_parts_array_into_cache($host, $array)
{
	$file_name=hopp_get_file_name_from_md5($host, $array["DOC_MD5"]);
	hopp_put_generic_array_into_cache($file_name.".parts", $array);
}

function hopp_put_generic_array_into_cache($file_name, $object, $first=1, $serialize=1)
{
	if($serialize)
		$object=serialize($object);
	$file_ptr=@fopen($file_name,"w");
	if($file_ptr)
	{
		fwrite ($file_ptr, $object);
		fclose($file_ptr);
	}
	else
	{	
		if($first)
		{
			hopp_check_cache_dir($file_name);
			hopp_put_generic_array_into_cache($file_name, $object, 0, $serialize);
		}	
	}
}

function hopp_put_doc_md5_into_cache($file_name, $md5_doc)
{
	$md5_file_name="$file_name.md5";
	$md5_fizle_ptr=fopen($md5_file_name,"w");
	if($md5_file_ptr)
	{
		fwrite ($md5_file_ptr, $md5_doc);
		fclose($md5_file_ptr);
	}
}

function hopp_include_local_doc_array_from_cache($param_string, $ttl, $check_old=1)
{
	$file_name=hopp_get_file_name_from_string($param_string).".doc";
	if($check_old)
		if(hopp_is_old_cache_file($ttl, $file_name))
			return;
	if(file_exists($file_name))	
		if(filesize ($file_name))
		{
			include $file_name;
			return 1;
		}
}

function hopp_get_doc_array_from_cache($host, $url, $check_old=1)
{
	return hopp_get_remote_doc_array_from_cache($host, $url, $check_old);
}

function hopp_get_remote_doc_array_from_cache($host, $url, $check_old=1)
{
	global $__TTL__;
	$file_name=hopp_get_file_name_from_url($host, $url).".doc";
	return hopp_get_generic_array_from_cache($__TTL__[$host], $file_name, $check_old);
}

function hopp_get_old_remote_doc_array_from_cache($host, $url)
{
	return hopp_get_remote_doc_array_from_cache($host, $url, 0);
}

function hopp_get_local_doc_array_from_cache($param_string, $ttl, $check_old=1)
{
	$file_name=hopp_get_file_name_from_string($param_string).".doc";
	return hopp_get_generic_array_from_cache($ttl, $file_name, $check_old,0);
}

function hopp_get_old_local_doc_array_from_cache($param_string, $ttl)
{
	return hopp_get_local_doc_array_from_cache($param_string, $ttl, 0);
}

function hopp_get_parts_array_from_cache($host, $url)
{
	global $__TTL__;
	$file_name=hopp_get_file_name_from_url($host, $url).".md5";
	$md5doc=hopp_get_generic_array_from_cache($__TTL__[$host], $file_name, 1);
	#s_log("md5doc: $md5doc");
	if(strlen($md5doc)==32)
	{
		$file_name=hopp_get_file_name_from_md5($host, $md5doc).".parts";
		return hopp_get_generic_array_from_cache($__TTL__[$host], $file_name, 0);
	}	
}

function hopp_get_generic_array_from_cache($ttl, $file_name, $check_old, $unserialize=1)
{
	#s_log("Looking for $file_name");
	if(file_exists($file_name))
	{
		#s_log("Looking for $file_name: exists");
		if($check_old)
			if(hopp_is_old_cache_file($ttl, $file_name))
				return;
				
	}
	return hopp_get_array_from_cache_file($file_name, $unserialize);
}

function hopp_get_array_from_cache_file($file_name, $unserialize=1)
{
	if(file_exists($file_name))
	{
		$file_ptr=fopen($file_name,"r");
		if($file_ptr)
		{
			$file=fread($file_ptr,filesize($file_name));
			##s_log("===========> file <===========\n $file\n=================================");
			fclose($file_ptr);
			if($unserialize)
				$file=unserialize($file);
			return $file;
		}
	}
}

function hopp_is_old_cache_file($ttl, $file_name)
{
	$oldtime=time()-filemtime ($file_name);
	#s_log("file_name: $file_name\toldtime: $oldtime");
	if($oldtime>$ttl)
		return 1;
}

function hopp_get_file_name_from_url($host, $url)
{
	return hopp_get_file_name_from_host_and_string($host, $url);
}

function hopp_get_file_name_from_string($string)
{
	return hopp_get_file_name_from_host_and_string('HOPP', $string);
}

function hopp_get_file_name_from_host_and_string($host, $string)
{
	$hash_pre=md5($string);
	//#s_log("hash_pre: $hash_pre");
	return hopp_get_file_name_from_md5($host, $hash_pre);
}

function hopp_get_file_name_from_md5($host, $hash_pre)
{
	$time_0=s_time();
	$subdir=substr($hash_pre,0,__HOPP_BASIC_CACHE_DEPTH);
	$hash=substr($hash_pre,__HOPP_BASIC_CACHE_DEPTH,32);
	#s_log("MD5\nhash_pre:\t$hash_pre\nsubdir\t\t$subdir\nhash:\t\t$hash");
	
	$filename=__HOPP_BASIC_CACHE_DIR_NAME."/$host/$subdir/$hash";

	$time_1=s_time();
	#s_log("Cache Filename Time:\t".($time_1-$time_0));
	return $filename;
}

function hopp_check_cache_dir($filename, $hops=0)
{
	if($hops>__HOPP_BASIC_CACHE_DIR_MAX_HOPS)
		return;
	if(ereg("\/", $filename))
		$dirname=dirname($filename);
	else
		$dirname=$filename;
	#s_log("filename: $filename\tdirname: $dirname\thops: $hops");
	
	if(!file_exists($dirname))
	{
		if(ereg("\/", $dirname))
			hopp_check_cache_dir($dirname, $hops+1);
		mkdir($dirname, __HOPP_BASIC_CACHE_DIR_MODE);
	}
}

//--------------------------------------------------------------------
} //__HOPP_BASIC_CACHE_
?>
