<?
# Module: Calendar
# cal-dir.inc Copyright (C) 2002 Sandino Araico Snchez
/* --LICENSE IN US ENGLISH----------------------------------------------------- 
 * "THE BEER-WARE LICENSE" (Revision 42-sandino-3): 
 * Sandino Araico Snchez <sandino@sandino.net> wrote this file. 
 * As long as you retain this notice you can do whatever you want with this 
 * software. If we meet some day, and you think this stuff is worth it, you can 
 * buy me a beer in return. 
 * Sandino Araico Snchez 
 * --END LICENSE---------------------------------------------------------------
 * --LICENCIA EN ESPAOL MEXICANO----------------------------------------------
 * "LA LICENCIA BEER-WARE" (traduccin al espaol de la revisin 42-sandino-3):
 * Sandino Araico Snchez <sandino@sandino.net> escribi ste archivo.
 * Siempre y cuando usted retenga ste aviso (en espaol y en ingls) usted
 * puede hacer cualquier cosa con ste software. Si algn da nos encontramos y 
 * usted piensa que ste software vale la pena, usted puede invitarme una 
 * cerveza en recompensa.
 * Sandino Araico Snchez
 * --FIN DE LICENCIA-----------------------------------------------------------
 */

# Changelog
# 2002-05-02 Sandino Araico Snchez - navegador de calendario
# 2002-05-06 Sandino Araico Snchez - dir-contents, year, minth, day, filtered

# TODO
# 2002-05-10 Sandino Araico Snchez - multi-pass in-memory optimization

if(!defined("__CALENDAR_DIR"))
{
define ("__CALENDAR_DIR",1);
#---------------------------------------------------------------------
if(!defined('__CALENDAR_YEAR_FORMAT'))
	define('__CALENDAR_YEAR_FORMAT','D');
if(!defined('__CALENDAR_MONTH_FORMAT'))
	define('__CALENDAR_MONTH_FORMAT','D');
if(!defined('__CALENDAR_DAY_FORMAT'))
	define('__CALENDAR_DAY_FORMAT','F');
if(!defined('__CALENDAR_VALIDATE_NAME_STRICT'))	
	define('__CALENDAR_VALIDATE_NAME_STRICT',0);
if(!defined('__CALENDAR_CONSTANTS'))
{
	define('__CALENDAR_CONSTANTS',1);
	
	define('__CALENDAR_TYPE_YEAR',101);
	define('__CALENDAR_TYPE_MONTH',102);
	define('__CALENDAR_TYPE_DAY',103);

	define('__CALENDAR_FORMAT_DIR',111);
	define('__CALENDAR_FORMAT_FILE',112);

	define('__CALENDAR_FLAGS_RETURN_NAME',1);
	define('__CALENDAR_FLAGS_RETURN_FILE',2);
	define('__CALENDAR_FLAGS_RETURN_BOTH',3);
	define('__CALENDAR_FLAGS_RETURN_DEFAULT',__CALENDAR_FLAGS_RETURN_NAME);
} // __CALENDAR_CONSTANTS
#---------------------------------------------------------------------
include __HOPP_INCLUDE_PATH."s.inc";
#---------------------------------------------------------------------
# High level functions (must be documented)

function cal_get_years_from_dir($dirname, $start=0, $length=0, $flags=0)
{
	s_log("Dir: $dirname\tstart: $start length: $length");
	return cal_get_files_from_dir($dirname,__CALENDAR_TYPE_YEAR, $start, $length,0, $flags);
}

function cal_get_months_from_dir($dirname, $start=0, $length=0, $year='', $y_start=0, $flags=0)
{
	s_log("Dir: $dirname\tstart: $start length: $length");
	if($year)
		$filter[]=array('N'=>$year,'S'=>$y_start,'L'=>strlen($year));
	return cal_get_files_from_dir($dirname,__CALENDAR_TYPE_MONTH, $start, $length, $filter, $flags);
}

function cal_get_days_from_dir($dirname, $start=0, $length=0, $month='', $m_start=0, $year='', $y_start=0, $flags=0, $day='',$d_start=0)
{
	s_log("Dir: $dirname\tstart: $start length: $length");
	if($month)
		$filter[]=array('N'=>$month,'S'=>$m_start,'L'=>strlen($month));
	if($year)
		$filter[]=array('N'=>$year,'S'=>$y_start,'L'=>strlen($year));
	if($day)
		$filter[]=array('N'=>$day,'S'=>$d_start,'L'=>strlen($day));
	return cal_get_files_from_dir($dirname,__CALENDAR_TYPE_DAY, $start, $length, $filter, $flags);
}

#---------------------------------------------------------------------
# Medium level functions (should be documented)

# This should sometimes be faster than cal_get_days_from_dir();
function cal_get_filtered_files_from_dir($dirname, $year='', $y_start=0, $month='', $m_start=0, $day='',$d_start=0)
{
	s_log("Dir: $dirname\tyear: $year\tmonth: $month\tday: $day");
	if($year)
		$filter[]=array('N'=>$year,'S'=>$y_start,'L'=>strlen($year));
	if($month)
		$filter[]=array('N'=>$month,'S'=>$m_start,'L'=>strlen($month));
	if($day)
		$filter[]=array('N'=>$day,'S'=>$d_start,'L'=>strlen($day));
	return cal_get_files_from_dir($dirname,0, 0, 0, $filter, __CALENDAR_FLAGS_RETURN_FILE);
}
#---------------------------------------------------------------------
# Low (full power) level functions (want documentation? here's the code)

function cal_get_files_from_dir($dirname,$type=__CALENDAR_TYPE_YEAR, $start=0, $length=0, $filter=0, $flags=0)
{
	if(empty($flags))
		$flags=__CALENDAR_FLAGS_RETURN_DEFAULT;
	if(($flags & __CALENDAR_FLAGS_RETURN_BOTH) == __CALENDAR_FLAGS_RETURN_BOTH) $flags_both=1;
	else if (($flags & __CALENDAR_FLAGS_RETURN_FILE) == __CALENDAR_FLAGS_RETURN_FILE) $flags_file = 1;
	else if (($flags & __CALENDAR_FLAGS_RETURN_NAME) == __CALENDAR_FLAGS_RETURN_NAME) $flags_name = 1;
	s_log("Looking for files in $dirname");
	switch($type)
	{
	case __CALENDAR_TYPE_YEAR:
		$format=cal_get_format_from_param(__CALENDAR_YEAR_FORMAT);
		break;
	case __CALENDAR_TYPE_MONTH:
		$format=cal_get_format_from_param(__CALENDAR_MONTH_FORMAT);
		break;
	case __CALENDAR_TYPE_DAY:
		$format=cal_get_format_from_param(__CALENDAR_DAY_FORMAT);
		break;
	case 0:
		$format=0;
		break;
	default:
		$format=cal_get_format_from_param(__CALENDAR_MONTH_FORMAT);
	}
	s_log("dirname: $dirname");
	$dir=opendir ($dirname);
	if($dir)
	{
		while($file=readdir($dir))
		{
			if($start)
			{
				if($length)
					$name=substr($file,$start,$length);
				else	
					$name=substr($file,$start);
			}
			else
				$name=$file;
			#s_log("Dir file: $file\tstart: $start length: $length");
			s_log("File: $file\tformat: $format");
			if(cal_is_valid_dir_line($dirname,$file, $name, $format, $filter))
			{
				s_log("Valid file: $file");
				$array_file[]=$file;
				$array_name[]=$name;
			}
		}
		closedir($dir);
	}
	if(is_array($array_file)) asort($array_file);
	else return 0;
	if(is_array($array_name)) asort($array_name,SORT_NUMERIC);
	else return 0;
	if($flags_both)
		return array(
			'FILES'=>$array_file,
			'NAMES'=>$array_name,
			'FILES_U'=>array_unique($array_file),
			'NAMES_U'=>array_unique($array_name)
		);
	else if($flags_file)	
		return array_unique($array_file);
	else if($flags_name)	
		return array_unique($array_name);
	return 0;
}

function cal_get_format_from_param($param)
{
	s_log("param: $param");
	switch($param)
	{
	case 'D':
		s_log('return __CALENDAR_FORMAT_DIR');
		return __CALENDAR_FORMAT_DIR;
	case 'F':
		s_log('return __CALENDAR_FORMAT_FILE');
		return __CALENDAR_FORMAT_FILE;
	case 'd': case 'DIR': case 'dir':
		s_log('return __CALENDAR_FORMAT_DIR');
		return __CALENDAR_FORMAT_DIR;
	case 'f': case 'FILE': case 'file': 
		s_log('return __CALENDAR_FORMAT_FILE');
		return __CALENDAR_FORMAT_FILE;
	default:
		s_log_error("Using default format for $param");
		return __CALENDAR_FORMAT_DIR;
	}
}

function cal_is_valid_dir_line($dir,$file, $name, $format=__CALENDAR_FORMAT_DIR, $filter=0)
{
	#s_log("dir: $dir\tfile: $file\tformat: $format");
	if(is_array($filter))
	{	
		foreach($filter as $ifi)
		{
			if(!cal_is_valid_dir_filtered_name($file, $ifi)) return 0;
		}	
	}
	if($format)
	{
		if(!cal_is_valid_dir_line_name($name)) return 0;
		switch($format)
		{
		case __CALENDAR_FORMAT_DIR:
			return cal_is_valid_dir_line_dir($dir,$file);
		case __CALENDAR_FORMAT_FILE:
			return cal_is_valid_dir_line_file($dir,$file);
		}
		s_log_error("Not a known format $format for $dir/$file");
	}	
	return 1;
}

function cal_is_valid_dir_line_dir($dir,$file)
{
	s_log("dir: $dir\tfile: $file");
	if(!is_dir("$dir/$file")) return 0;
	return 1;	
}

function cal_is_valid_dir_line_file($dir,$file)
{
	s_log("dir: $dir\tfile: $file");
	if(!is_file("$dir/$file")) return 0;
	return 1;
}

function cal_is_valid_dir_filtered_name($file, $filter=0)
{
	if(is_array($filter))
	{
		if($filter['N'])
		{	
			s_log('Using filter: '.$filter['N']);
			$name=substr($file,$filter['S'], $filter['L']);
			s_log("Filter name: $name");
			if($name != $filter['N']) return 0;
		}
	}
	return 1;
}

function cal_is_valid_dir_line_name($name)
{
	if(__CALENDAR_VALIDATE_NAME_STRICT)
	{
		$fslen=strlen($name);
		s_log("fslen: $fslen");
		if(($fslen<1)||($fslen>4)) return 0;
		s_log("fslen: OK");
	}
	if(!is_numeric($name)) return 0;
	s_log("Is Numeric $name: OK");
	if(__CALENDAR_VALIDATE_NAME_STRICT)
	{
		if(!s_is_int($name)) return 0;	
		s_log("Is Int $name: OK");
	}	
	return 1;	
}

#---------------------------------------------------------------------
} // __CALENDAR_DIR
?>
