<?
# Module: DB
# hopp-dbfunctions-pg.inc Copyright (C) 2000-2002 Sandino Araico Snchez
/* --LICENSE IN US ENGLISH----------------------------------------------------- 
 * "THE BEER-WARE LICENSE" (Revision 42-sandino-3): 
 * Sandino Araico Snchez <sandino@sandino.net> wrote this file. 
 * As long as you retain this notice you can do whatever you want with this 
 * software. If we meet some day, and you think this stuff is worth it, you can 
 * buy me a beer in return. 
 * Sandino Araico Snchez 
 * --END LICENSE---------------------------------------------------------------
 * --LICENCIA EN ESPAOL MEXICANO----------------------------------------------
 * "LA LICENCIA BEER-WARE" (traduccin al espaol de la revisin 42-sandino-3):
 * Sandino Araico Snchez <sandino@sandino.net> escribi ste archivo.
 * Siempre y cuando usted retenga ste aviso (en espaol y en ingls) usted
 * puede hacer cualquier cosa con ste software. Si algn da nos encontramos y 
 * usted piensa que ste software vale la pena, usted puede invitarme una 
 * cerveza en recompensa.
 * Sandino Araico Snchez
 * --FIN DE LICENCIA-----------------------------------------------------------
 */
 
# Changelog: 
# 2000-09-08 Sandino Araico Snchez
# 2002-02-06 Sandino Araico Snchez - transaction functions now return a value

if(!defined("__HOPP_DBFUNCTIONS"))
{
define("__HOPP_DBFUNCTIONS",1);
#----------------------------------------------------------------------------
#----------------------------------------------------------------------------

function hopp_db_config()
{
	if(file_exists("db-params.inc.php"))
		include "db-params.inc.php";
	else if (file_exists("db/postgres/db-params.inc.php"))	
		include __HOPP_INCLUDE_PATH."db/postgres/db-params.inc.php";
}

function hopp_db_connect()
{
	if(!defined("__HOPP_DBPARAMS_PG"))
	hopp_db_config();
	s_log("__HOPP_DBPARAMS_PG: ".__HOPP_DBPARAMS_PG);
	s_log("__HOPP_DB_NAME: ".__HOPP_DB_NAME);
	if(defined("__HOPP_DBPARAMS_PG"))
	{
		if(defined("__HOPP_DB_CONNECT_PERSISTENT"))
			return pg_pconnect(__HOPP_DB_HOST, __HOPP_DB_PORT, __HOPP_DB_OPTIONS, __HOPP_DB_TTY, __HOPP_DB_NAME);
		else	
			return pg_connect(__HOPP_DB_HOST, __HOPP_DB_PORT, __HOPP_DB_OPTIONS, __HOPP_DB_TTY, __HOPP_DB_NAME);
	}	
}

function hopp_db_release($id)
{
	pg_close ($id);
}

function hopp_db_connected($id)
{
	return ($id?$id:hopp_db_connect());
}

function hopp_db_start_transaction($id)
{
	return hopp_db_exec($id, "begin");
}

function hopp_db_end_transaction($id)
{
	return hopp_db_exec($id, "commit");
}

function hopp_db_rollback_transaction($id)
{
	return hopp_db_exec($id, "rollback");
}

function hopp_db_exec($id, $sql)
{
	return pg_exec($id, $sql);
}

function hopp_db_get_sequential_id($id, $seq_name)
{
	$sql="select nextval('$seq_name')";
	return hopp_db_get_single_field_result($id, $sql);
}

function hopp_db_get_single_field_result($id, $sql)
{
	$cur=hopp_db_exec($id, $sql);
	if(pg_numrows($cur))
		return pg_result($cur,0,0);
}

function hopp_db_get_single_field_result_decoded($id, $sql)
{
	return rawurldecode(hopp_db_get_single_field_result($id, $sql));
}

function hopp_db_get_n_row_array_result($cur, $row)
{
	return pg_fetch_array ($cur, $row, PGSQL_ASSOC);
}

function hopp_db_get_single_row_array_result($id, $sql)
{
	$cur=hopp_db_exec($id, $sql);
	if(pg_numrows($cur))
		return hopp_db_get_n_row_array_result($cur, 0);
}

function hopp_db_get_single_row_array_result_decoded($id, $sql)
{
	$array_orig=hopp_db_get_single_row_array_result($id, $sql);
	return hopp_db_decode_array($array_orig);
}

function hopp_db_decode_array($array_orig)
{
	if(!is_array($array_orig))
		return;
	while(list($key, $value)=each($array_orig))
		$array[$key]=rawurldecode($value);
	return $array;	
}

function hopp_db_get_multi_row_array_result($id, $sql)
{
	$cur=hopp_db_exec($id, $sql);
	$numrows=pg_numrows($cur);
	for($i=0;$i<$numrows;$i++)
	{
		$result_array[$i]=hopp_db_get_n_row_array_result($cur, $i);
	}
	return $result_array;
}

function hopp_db_get_multi_row_array_result_decoded($id, $sql)
{
	$array_orig=hopp_db_get_multi_row_array_result($id, $sql);
	return hopp_db_decode_multi_row_array($array_orig);
}

function hopp_db_decode_multi_row_array($array_orig)
{
	if(!is_array($array_orig))
		return;
	while(list($key, $value)=each($array_orig))
		$array[$key]=hopp_db_decode_array($value);
	return $array;	
}

#----------------------------------------------------------------------------
} // __HOPP_DBFUNCTIONS
?>
