#!/bin/sh
# Module: MIME 
# build-mime-types.sh Copyright (C) 2002 Sandino Araico Snchez
# --LICENSE IN US ENGLISH----------------------------------------------------- 
# "THE BEER-WARE LICENSE" (Revision 42-sandino-3): 
# Sandino Araico Snchez <sandino@sandino.net> wrote this file. 
# As long as you retain this notice you can do whatever you want with this 
# software. If we meet some day, and you think this stuff is worth it, you can 
# buy me a beer in return. 
# Sandino Araico Snchez 
# --END LICENSE---------------------------------------------------------------
# --LICENCIA EN ESPAOL MEXICANO----------------------------------------------
# "LA LICENCIA BEER-WARE" (traduccin al espaol de la revisin 42-sandino-3):
# Sandino Araico Snchez <sandino@sandino.net> escribi ste archivo.
# Siempre y cuando usted retenga ste aviso (en espaol y en ingls) usted
# puede hacer cualquier cosa con ste software. Si algn da nos encontramos y 
# usted piensa que ste software vale la pena, usted puede invitarme una 
# cerveza en recompensa.
# Sandino Araico Snchez
# --FIN DE LICENCIA-----------------------------------------

# Changelog:
# 2002-05-16 Sandino Araico Snchez - Script to build mime-types.inc
 
cat > mime-types.inc <<EOF
<?
# Module: MIME 
# mime-types.inc 
/* This is an automatically-generated file.
 * The source file is mime.src.
 * This file should not be edited by hand, instead mime.src should be edited 
 * and ./build-mime-types.sh should be executed after.
 *
 * Este es un archivo generado automticamente.
 * El archivo fuente es mime.src.
 * Este archivo no debe editarse a mano, en su lugar debe esitarse mime.src
 * y despus ./build-mime-types.sh debe ser ejecutado.
 */

if(!defined("__HOPP_MIME_TYPES"))
{
define ("__HOPP_MIME_TYPES",1);
#---------------------------------------------------------------------

EOF

for i in `cat mime.src | grep -v '#' | cut -d ' ' -f 1` ; do
	for j in `cat mime.src | grep $i | cut -d ' ' -f 2-999` ; do
		k=`echo $j | sed 's/^\.//'`
		echo "if(!defined('__HOPP_MIME_TYPE_$k'))" >> mime-types.inc
		echo "	define ('__HOPP_MIME_TYPE_$k', '$i');" >> mime-types.inc
	done
done

cat >> mime-types.inc <<EOF
#---------------------------------------------------------------------
} //__HOPP_MIME_TYPES
?>
EOF

