<?
# Module: MIME 
# mime-functions.inc Copyright (C) 2002 Sandino Araico Snchez
/* --LICENSE IN US ENGLISH----------------------------------------------------- 
 * "THE BEER-WARE LICENSE" (Revision 42-sandino-3): 
 * Sandino Araico Snchez <sandino@sandino.net> wrote this file. 
 * As long as you retain this notice you can do whatever you want with this 
 * software. If we meet some day, and you think this stuff is worth it, you can 
 * buy me a beer in return. 
 * Sandino Araico Snchez 
 * --END LICENSE---------------------------------------------------------------
 * --LICENCIA EN ESPAOL MEXICANO----------------------------------------------
 * "LA LICENCIA BEER-WARE" (traduccin al espaol de la revisin 42-sandino-3):
 * Sandino Araico Snchez <sandino@sandino.net> escribi ste archivo.
 * Siempre y cuando usted retenga ste aviso (en espaol y en ingls) usted
 * puede hacer cualquier cosa con ste software. Si algn da nos encontramos y 
 * usted piensa que ste software vale la pena, usted puede invitarme una 
 * cerveza en recompensa.
 * Sandino Araico Snchez
 * --FIN DE LICENCIA-----------------------------------------------------------
 */
 
# Changelog: 
# 2002-01-05 Sandino Araico Snchez - Functions for mime types
# 2002-01-29 Sandino Araico Snchez - Corrected file name notice
# 2002-02-06 Sandino Araico Snchez - application/msword
# 2002-02-08 Sandino Araico Snchez - h_mime_set_doc_name_headers()
# 2002-05-16 Sandino Araico Snchez - Cambio de nombre a mime-functions.inc
#	- Nuevos tipos
# 	- Optimizacin en h_mime_get_mime_content_type(), uso de constantes 
# 	definidas en mime-types.inc en lugar del switch hardcodeado
# 	- Otros tipos se pueden definir antes de incluir mime.inc

if(!defined("__HOPP_MIME_FUNCTIONS"))
{
define ("__HOPP_MIME_FUNCTIONS",1);
#---------------------------------------------------------------------
function h_mime_get_mime_headers($doc)
{
	h_mime_set_mime_headers($doc);
}

function h_mime_set_mime_headers($doc)
{
	$ext=h_mime_get_file_extension($doc);
	if(empty($ext))
		$content_type='application/octet-stream';
	else
		$content_type=h_mime_get_mime_content_type($ext);
	s_log("content_type: $content_type");	
	header("Content-Type: $content_type");	
}

function h_mime_get_file_extension($doc)
{
	if(eregi('\.([a-z0-9_]+)$', $doc, $regs))
	{
		s_log("EXT: $regs[0]");
		return $regs[1];
	}
}

function h_mime_set_doc_name_headers($doc)
{
	$doc=basename($doc);
	s_log("Content-Disposition: attachment; filename=$doc");
	header("Content-Disposition: attachment; filename=$doc");
}

function h_mime_get_mime_content_type($ext)
{
	$ext=strtolower($ext);
	$type="__HOPP_MIME_TYPE_$ext";
	if(defined($type))
		return constant($type);
	return 'application/octet-stream';
}
#---------------------------------------------------------------------
} //__HOPP_MIME_FUNCTIONS

?>
