<?
#Module: poll
# poll-core.inc Copyright (C) 2001 Sandino Araico Snchez
/* --LICENSE IN US ENGLISH----------------------------------------------------- 
 * "THE BEER-WARE LICENSE" (Revision 42-sandino-3): 
 * Sandino Araico Snchez <sandino@sandino.net> wrote this file. 
 * As long as you retain this notice you can do whatever you want with this 
 * software. If we meet some day, and you think this stuff is worth it, you can 
 * buy me a beer in return. 
 * Sandino Araico Snchez 
 * --END LICENSE---------------------------------------------------------------
 * --LICENCIA EN ESPAOL MEXICANO----------------------------------------------
 * "LA LICENCIA BEER-WARE" (traduccin al espaol de la revisin 42-sandino-3):
 * Sandino Araico Snchez <sandino@sandino.net> escribi ste archivo.
 * Siempre y cuando usted retenga ste aviso (en espaol y en ingls) usted
 * puede hacer cualquier cosa con ste software. Si algn da nos encontramos y 
 * usted piensa que ste software vale la pena, usted puede invitarme una 
 * cerveza en recompensa.
 * Sandino Araico Snchez
 * --FIN DE LICENCIA-----------------------------------------------------------
 */
 
# Changelog: 
# 2001-09-17 Sandino Araico Snchez <sandino@sandino.net>
#	Librera para hacer encuestas (una ms de tantas encuestass en PHP)	
# 2001-09-25 Sandino Araico Snchez <sandino@sandino.net>
#	Funciones de poll en librera dependiente	
# 2001-10-01 Sandino Araico Snchez <sandino@sandino.net>
#	Votos tipo M y D
# 	Resultados tipo M
# 2001-10-03 Sandino Araico Snchez <sandino@sandino.net>
#	Footer de los radios
# 2001-11-19 Sandino Araico Snchez <sandino@sandino.net>
#	Banned IP addresses with min and max timestamp
#	Check for existing cookies
# 2001-11-20 Sandino Araico Snchez <sandino@sandino.net>
# 	Banned IP addresses in total votes count
#	Fixed cookie Bug, avoid multiple votes

if(!defined("__H_POLL_CORE__"))
{
define("__H_POLL_CORE__",1);
#------------------------------------------------------------------------------
#------------------------------------------------------------------------------
function h_poll_put_comment($id, $cookie, $POLL)
{
	if(empty($cookie))
		return;
	s_log("Checking for existing cookie: $cookie");	
	if(!h_poll_cookie_exists($id, $cookie))
		return;
	s_log("Ckecking for sent comment: $cookie");	
	if(h_poll_sent_comment($id, $cookie, $POLL))
		return;

	$det_name='comment-'.$POLL;
	global $$det_name;
	$det_value=$$det_name;
	if($det_value)
	{
		#s_log("det_value: $det_value");
		#h_poll_put_comment($id, $cookie, $POLL, $det_value);
		$sql="insert into h_poll_comment (pll_com_key, pll_com_poll, pll_com_cookie, pll_com_txt) values (nextval('s_poll_comment'), $POLL, '$cookie', '$det_value')";
		#s_log("sql: $sql");
		hopp_db_exec($id, $sql);
	}
}

function h_poll_sent_comment($id, $cookie,$KEY)
{
	$sql="select count(pll_com_txt) from h_poll_comment where pll_com_poll = $KEY and pll_com_cookie = '$cookie'";
	s_log("sql: $sql");
	return hopp_db_get_single_field_result($id, $sql);
}

function h_poll_get_comment()
{
	global $H_PLL_COMMENT;
	#s_log("H_PLL_COMMENT: $H_PLL_COMMENT");
	if(!empty($H_PLL_COMMENT))
		return $H_PLL_COMMENT;
}

function h_poll_put_votes($id, $cookie, $POLL)
{
	#s_log("h_poll_put_votes\tcookie: $cookie\tPOLL: $POLL");
	if(empty($cookie))
		return;
	if(!h_poll_cookie_exists($id, $cookie))
		return;
	if(h_poll_used_cookie($id, $cookie, $POLL))
		return;

	$sql="select pll_det_key from h_poll_det where pll_det_poll = $POLL" ;
	#s_log("sql: $sql");
	$res_pre=hopp_db_get_multi_row_array_result($id, $sql);
	foreach ($res_pre as $value)
	{
		#s_log ("value:".$value['pll_det_key']);
		$res[]=$value['pll_det_key'];
	}
	$poll=h_poll_get($id, $POLL);
	#s_log("poll: $poll\tTYPE: ".$poll['TYPE']);
	switch($poll['TYPE'])
	{
	case "D":
		$table=h_poll_put_votes_d($id, $cookie, $POLL, $res);
		break;
	case "S":	
		$table=h_poll_put_votes_s($id, $cookie, $POLL, $res);
		break;
	case "M":	
		$table=h_poll_put_votes_m($id, $cookie, $POLL, $res);
		break;
	}
}

function h_poll_cookie_exists($id, $cookie)
{
	$sql="select count(*) from h_poll_cookie where pll_coo_cookie = '$cookie'";
	#s_log("sql: $sql");
	return hopp_db_get_single_field_result($id, $sql);
}

function  h_poll_put_votes_d($id, $cookie, $POLL, $res)
{
	foreach($res as $value)
	{
		$det_name='row-'.$value;
		global $$det_name;
		$det_value=$$det_name;

		#s_log("det_name: $det_name: $det_value");
		if($det_value)
		{
			$sql="insert into h_poll_vot (pll_vot_key, pll_vot_det, pll_vot_cookie, pll_vot_date, pll_vot_value) values (nextval('s_poll_vot'), $value, '$cookie', 'now', $det_value)";
			#s_log("sql: $sql");
			hopp_db_exec($id, $sql);
		}
	}
}

function  h_poll_put_votes_m($id, $cookie, $POLL, $res)
{
	$det_name='det-'.$POLL;
	global $$det_name;
	$det_value=$$det_name;
	#s_log("det_name: $det_name: $det_value");
	if(in_array ($det_value, $res))
	{
		$sql="insert into h_poll_vot (pll_vot_key, pll_vot_det, pll_vot_cookie, pll_vot_date) values (nextval('s_poll_vot'), $det_value, '$cookie', 'now')";
		#s_log("sql: $sql");
		hopp_db_exec($id, $sql);
	}
}

function  h_poll_put_votes_s($id, $cookie, $POLL, $res){}

function h_poll_get_cookie($clave)
{
	global $cookie_name;
	$cookie_name="hopp_poll_$clave";
	s_log("cookie_name: $cookie_name");
	global $$cookie_name, $REMOTE_ADDR;
	return $$cookie_name;
}

function h_poll_set_cookie($id, $clave)
{
	global $cookie_name;
	$cookie_name="hopp_poll_$clave";
	#s_log("cookie_name: $cookie_name");
	global $$cookie_name, $REMOTE_ADDR;
	if(empty($$cookie_name))
	{
		$cookie_expire=mktime(date("H"),date("i"),date("s"),date("m"),date("d"),date("Y")+1);
		$cookie_seq=hopp_db_get_sequential_id($id, "s_poll_cookie");
		switch(__H_POLL_COOKIE_METHOD)
		{
		case 'IP':
			$cookie_val=md5("$clave:$REMOTE_ADDR"); // use poll key combined with IP
			$sql="select pll_coo_key from h_poll_cookie where pll_coo_cookie = '$cookie_val'";
			if(hopp_db_get_single_field_result($id, $sql))
				$insert=0;
			else
				$insert=1;
			break;
		case 'seq':
			$cookie_val=md5($cookie_seq);
			$insert=1;
			break;
		}
		if($insert)
			$sql="insert into h_poll_cookie (pll_coo_key, pll_coo_poll, pll_coo_cookie, pll_coo_ip, pll_coo_date) values ($cookie_seq, $clave, '$cookie_val', '$REMOTE_ADDR', 'now')";
		hopp_db_exec($id, $sql);
		$$cookie_name=$cookie_val;
		if(__H_POLL_COOKIE_METHOD=='seq')
			setcookie($cookie_name, $cookie_val, $cookie_expire);
	}
	return $$cookie_name;
}

function h_poll_used_cookie($id, $cookie, $poll=0, $det=0)
{
	$sql="select pll_vot_key from h_poll_vot where pll_vot_cookie = '$cookie'";
	if($poll)
		$sql.=" and pll_vot_det in (select pll_det_key from h_poll_det where pll_det_poll = $poll)";
	else if($det)
		$sql.=" and pll_vot_det = $det";
	s_log("sql: $sql");	
	return hopp_db_get_single_field_result($id, $sql);
}

function h_poll_unused_cookie($id, $cookie,$key,$span)
{
	for($i=0;$i<$span;$i++)
	{
		if(h_poll_used_cookie($id, $cookie, $i))
			continue;
		return 1;	
	}
	return 0;
}

function h_poll_get($id, $clave)
{
	$sql="select pll_name, pll_type from h_poll where pll_key = $clave and pll_active = 'S'";
	#s_log("sql: $sql");
	$res=hopp_db_get_single_row_array_result($id, $sql);
	if(is_array($res))
	{
		foreach($res as $key => $value)
		{
			#s_log("KEY: $key\tVALUE: $value");
		}
		$array['NAME']=$res['pll_name'];
		$array['TYPE']=$res['pll_type'];
		$array['KEY']=$clave;
		switch($array["TYPE"])
		{
		case "D": case "S": case "M":
			$array['TABLE']=h_poll_get_table_array($id, $clave);
			break;
		}
		if(!is_array($array['TABLE']))
			return;
		return $array;
	}
}

function h_poll_get_table_array($id, $clave)
{
	$sql="select pll_det_key, pll_det_option from h_poll_det where pll_det_poll = $clave order by pll_det_order";
	#s_log("sql: $sql");
	$res=hopp_db_get_multi_row_array_result($id, $sql);
	if(is_array($res))
	{
		foreach ($res as $value)
		{
			$key=$value['pll_det_key'];
			$opcion=$value['pll_det_option'];
			#s_log("KEY: $key\tOPTION: $opcion");
			
			$array[$key]=$opcion;
		}
		return $array;
	}	
}

function h_poll_get_processed_table($id, $galleta, $KEY, $SPAN, $template_name, $form_submit=0)
{
	$span=$KEY+$SPAN;
	$tabla=""; //initialize variable
	for($i=$KEY;$i<$span;$i++)
	{
		$fragment=h_poll_get_table_fragment($id, $galleta, $i, $template_name, $form_submit);
		if(empty($fragment))
		{
			if(__H_POLL_SHOW_RESULTS)
				$fragment=h_poll_get_results_fragment($id, $i, $template_name);
		}
		$tabla.=$fragment;
	}
	return $tabla;
}

function h_poll_get_cached_table($id, $galleta, $template_name, $KEY=0, $SPAN=0, $form_submit=0)
{
	global $SERVER_NAME;
	if(empty($KEY))
		$KEY=__H_POLL_KEY;
	if(empty($SPAN))	
		$SPAN=__H_POLL_SPAN;
	$doc_id_string="$SERVER_NAME:$template_name:POLL:$KEY:$SPAN:$form_submit";
	s_log("doc_id_string: $doc_id_string");
	$doc_include=hopp_get_local_doc_array_from_cache($doc_id_string , __H_POLL_CACHE_TTL);
	if(empty($doc_include))
	{
		$doc_include=h_poll_get_processed_table($id, 0, $KEY, $SPAN, $template_name, $form_submit);
		$doc_put=hopp_put_local_doc_array_into_cache($doc_id_string, $doc_include);
	}
	return $doc_include;
}

function h_poll_get_table_fragment($id, $cookie, $POLL, $template_name, $form_submit)
{
	if(h_poll_used_cookie($id, $cookie, $POLL))
		return;
	if(!defined('__H_POLL_SHOW_SUBMIT'))	
		define('__H_POLL_SHOW_SUBMIT',1);
	global $SERVER_NAME;
	$doc_id_string="$SERVER_NAME:$template_name:POLL_TABLE_FRAGMENT:$POLL:$form_submit";
	s_log("doc_id_string: $doc_id_string");
	$doc_include=hopp_get_local_doc_array_from_cache($doc_id_string , __H_POLL_CACHE_TTL);
	if(empty($doc_include))
	{
		#s_log($id);
		$poll=h_poll_get($id, $POLL);
		$nombre=$poll['NAME'];
		#s_log("poll: $poll");
		#s_log("nombre: $nombre");
		$__templated_table=h_poll_template_table($poll, $template_name, $form_submit);
		$doc_put=hopp_put_local_doc_array_into_cache($doc_id_string, $__templated_table);
		$doc_include=hopp_get_local_doc_array_from_cache($doc_id_string , __H_POLL_CACHE_TTL, 0);
	}
	return $doc_include;

}

function h_poll_template_table($array, $template_name, $form_submit)
{
	switch($array['TYPE'])
	{
	case "D":
		$table=h_poll_template_table_d($array, $template_name);
		break;
	case "S":	
		$table=h_poll_template_table_s($array, $template_name);
		break;
	case "M":	
		$table=h_poll_template_table_m($array, $template_name, $form_submit);
		break;
	}
	$replace=array(
		'#####TABLE#####' => $table,
		'#####NAME#####'=> $array['NAME']
	);	
	$res=h_template_get_parsed_file($template_name, $replace, 1);	
	##s_log("=====> RES <=====\n$res\n========================");
	return $res;
}

function h_poll_template_table_d($array, $template_name)
{
	global $SCRIPT_NAME;
	$table_array=$array['TABLE'];
	$table=h_template_get_file($template_name."-head_radio");
	foreach($table_array as $key => $value)
	{
		$radio="";
		#s_log("key: $key\tvalue: $value");
		$replace=array(
			'#####TABLE_ROW_TITLE#####'=> $value
		);	
		$title=h_template_get_parsed_file($template_name."-table_row_title", $replace);	
		for($i=1;$i<=10;$i++)
		{
			$replace=array(
				'#####RADIO_NAME#####' => "row-$key",
				'#####RADIO_VALUE#####' => $i
			);	
			$radio.=h_template_get_parsed_file($template_name."-table_row_radio", $replace);
		}
		$replace=array(
			'#####RADIO_SET#####' => "$radio",
			'#####RADIO_TITLE#####' => $title
		);	
		$row=h_template_get_parsed_file($template_name."-table_row", $replace, 1);
		#s_log("row: $row");
		if($row)
			$table.=$row;
		else	
			$table.="\n<tr>\n$title\n$radio\n</tr>";
		
	}
	$table.="\n";
	$replace=array(
		'#####SCRIPT_NAME#####' => $SCRIPT_NAME
	);	
	$table.=h_template_get_parsed_file($template_name."-foot_radio", $replace);
	return $table;
}

function h_poll_template_table_s($array, $template_name)
{
	global $SCRIPT_NAME;
	$table_array=$array['TABLE'];
	$table=h_template_get_file($template_name."-head_radio");
	foreach($table_array as $key => $value)
	{
		$radio="";
		#s_log("key: $key\tvalue: $value");
		$replace=array(
			'#####TABLE_ROW_TITLE#####'=> $value
		);	
		$title=h_template_get_parsed_file($template_name."-table_row_title", $replace);	
		$s_ans=array(
			1 => 'Si',
			2 => 'No',
			3 => 'No se'
		);
		for($i=1;$i<=3;$i++)
		{
			$replace=array(
				'#####RADIO_NAME#####' => "row-$key",
				'#####RADIO_VALUE#####' => $s_ans[$i]
			);	
			$radio.=h_template_get_parsed_file($template_name."-table_row_radio", $replace);
		}
		$replace=array(
			'#####RADIO_SET#####' => "$radio",
			'#####RADIO_TITLE#####' => $title
		);	
		$row=h_template_get_parsed_file($template_name."-table_row", $replace, 1);
		#s_log("row: $row");
		if($row)
			$table.=$row;
		else	
			$table.="\n<tr>\n$title\n$radio\n</tr>";
		
	}
	$table.="\n";
	$replace=array(
		'#####SCRIPT_NAME#####' => $SCRIPT_NAME
	);	
	$table.=h_template_get_parsed_file($template_name."-foot_radio", $replace);
	return $table;
}

function h_poll_template_table_m($array, $template_name, $form_submit)
{
	global $SCRIPT_NAME;
	$table_array=$array['TABLE'];
	$table_key=$array['KEY'];
	$table="";
	foreach($table_array as $key => $value)
	{
		if($key==$form_submit)
		{
			 if(!empty($form_submit))
				$submit_string=h_template_get_file($template_name."-form_submit");
			s_log("submit_string: $submit_string");	
		}
		else
			$submit_string='';
		#s_log("key: $key\tvalue: $value");
		$replace=array(
			'#####TABLE_ROW_TITLE#####'=> $value
		);	
		$title=h_template_get_parsed_file($template_name."-table_row_title", $replace, 1);	
		$replace=array(
			'#####RADIO_NAME#####' => "det-$table_key",
			'#####SUBMIT_STRING#####' => $submit_string,
			'#####RADIO_VALUE#####' => $key
		);	
		$radio=h_template_get_parsed_file($template_name."-table_row_radio", $replace, 1);
		$replace=array(
			'#####RADIO_SET#####' => "$radio",
			'#####RADIO_TITLE#####' => $title
		);	
		$row=h_template_get_parsed_file($template_name."-table_row", $replace, 1);
		#s_log("row: $row");
		if($row)
			$table.=$row;
		else	
			$table.="\n<tr>\n$title\n$radio\n</tr>";
		
	}
	$table.="\n";
	$replace=array(
		'#####SCRIPT_NAME#####' => $SCRIPT_NAME
	);	
	$table.=h_template_get_parsed_file($template_name."-foot_radio", $replace);
	return $table;
}

function h_poll_get_processed_results($id, $KEY, $SPAN, $template_name)
{
	$span=$KEY+$SPAN;
	$tabla=""; //initialize variable
	for($i=$KEY;$i<$span;$i++)
		$tabla.=h_poll_get_results_fragment($id, $i, $template_name);
	return $tabla;
}

function h_poll_get_results_fragment($id, $POLL, $template_name)
{
	global $SERVER_NAME;
	$doc_id_string="$SERVER_NAME:$template_name:POLL-RESULT:$POLL";
	#s_log("doc_id_string: $doc_id_string");
	$doc_include=hopp_get_local_doc_array_from_cache($doc_id_string , __H_POLL_RESULTS_CACHE_TTL);
	if(empty($doc_include))
	{
		#s_log($id);
		$poll=h_poll_get($id, $POLL);
		$nombre=$poll['NAME'];
		#s_log("poll: $poll");
		#s_log("nombre: $nombre");
		$doc_include=h_poll_template_results($id, $poll, $template_name);
		$doc_put=hopp_put_local_doc_array_into_cache($doc_id_string, $doc_include);
	}
	return $doc_include;

}

function h_poll_template_results($id, $array, $template_name)
{
	switch($array['TYPE'])
	{
	case "D":
		$table=h_poll_template_results_d($id, $array, $template_name);
		break;
	case "S":	
		$table=h_poll_template_results_s($id, $array, $template_name);
		break;
	case "M":	
		$table=h_poll_template_results_m($id, $array, $template_name);
		break;
	}
	$replace=array(
		'#####TABLE#####' => $table,
		'#####NAME#####'=> $array['NAME']
	);	
	$res=h_template_get_parsed_file($template_name, $replace, 1);	
	##s_log("=====> RES <=====\n$res\n========================");
	return $res;
}

function h_poll_template_results_m($id, $array, $template_name)
{
	$table_array=$array['TABLE'];
	$poll=$array['KEY'];
	#$sql= "select count(distinct(pll_coo_key)) from h_poll_cookie, h_poll_vot where pll_coo_cookie = pll_vot_cookie and pll_coo_poll = $poll". h_poll_banned_ip();
	$sql= "select count(*) from h_poll_cookie, h_poll_vot where pll_coo_cookie = pll_vot_cookie and pll_vot_det in ( select pll_det_key from h_poll_det where pll_det_poll = $poll ) ". h_poll_banned_ip(); // This is a better count query; the one above is broken.
	#s_log("sql: $sql");
	$count=hopp_db_get_single_field_result($id, $sql);
	$replace=array(
		'#####COUNT#####' => $count
	);	
	$table=h_template_get_parsed_file($template_name."-head_result", $replace);
	if(defined("__H_POLL_BAR_WIDTH"))
		$bar_width=__H_POLL_BAR_WIDTH;
	else	
		$bar_width=100;
	$max=0;	
	foreach($table_array as $key => $value)
	{
		#s_log("key: $key\tvalue: $value");
		$sql="select count(pll_vot_key) from h_poll_vot where pll_vot_det = $key".h_poll_banned_ip();
		#s_log("sql: $sql");
		$sum=hopp_db_get_single_field_result($id, $sql);
		#s_log("sum: $sum");
		$sums[$key]=$sum;
		$max=$sum>$max?$sum:$max;
		#s_log("max: $max");
		#s_log("count: $count");
	}
	if($max==0) $max=1;
	foreach($table_array as $key => $value)
	{
		$radio="";
		#s_log("key: $key\tvalue: $value");
		$replace=array(
			'#####TABLE_ROW_TITLE#####'=> $value
		);	
		$title=h_template_get_parsed_file($template_name."-table_row_title", $replace);	
		$sum=$sums[$key];
		if($count)
		{
			$pct=(100*$sum)/$count;
			if($pct>0)
				$pct=sprintf("%.2f",$pct).'%';
		}
		else $pct=0;
		$left=round(($sum*$bar_width)/$max);
		$right=$bar_width-$left;
		if($left==0)
		{
			$left=1;
			$right-=1;
		}	
		if($right==0)
		{
			$right=1;
			$left-=1;
		}	
		$replace=array(
			'#####LEFT#####' => $left,
			'#####RIGHT#####' => $right,
			//'#####COUNT#####' => $count,
			'#####PCT#####' => $pct,
			'#####SUM#####' => $sum
		);	
		$radio=h_template_get_parsed_file($template_name."-table_row_bar", $replace);
		$replace=array(
			'#####RESULT_BAR#####' => "$radio",
			'#####RESULT_TITLE#####' => $title
		);	
		$row=h_template_get_parsed_file($template_name."-table_row_result", $replace, 1);
		##s_log("row: $row");
		if($row)
			$table.=$row;
		else	
			$table.="\n<tr>\n$title\n$radio\n</tr>";
		
	}
	$table.="\n";
	return $table;

}

function h_poll_template_results_d($id, $array, $template_name)
{
	$table_array=$array['TABLE'];
	$poll=$array['KEY'];
	$sql= "select count(distinct(pll_coo_key)) from h_poll_cookie, h_poll_vot where pll_coo_cookie = pll_vot_cookie and pll_coo_poll = $poll". h_poll_banned_ip();
	#s_log("sql: $sql");
	$count=hopp_db_get_single_field_result($id, $sql);
	$replace=array(
		'#####COUNT#####' => $count
	);	
	$table=h_template_get_parsed_file($template_name."-head_result", $replace);
	if(defined("__H_POLL_BAR_WIDTH"))
		$bar_width=__H_POLL_BAR_WIDTH;
	else	
		$bar_width=100;
	foreach($table_array as $key => $value)
	{
		$radio="";
		#s_log("key: $key\tvalue: $value");
		$replace=array(
			'#####TABLE_ROW_TITLE#####'=> $value
		);	
		$title=h_template_get_parsed_file($template_name."-table_row_title", $replace);	
		$sql="select avg(pll_vot_value) from h_poll_vot where pll_vot_det = $key".h_poll_banned_ip();
		#s_log("sql: $sql");
		$avg=hopp_db_get_single_field_result($id, $sql);
		$avg=1.0*$avg;
		#s_log("avg: $avg");
		$left=round(($avg*$bar_width)/10);
		$right=$bar_width-$left;
		$replace=array(
			'#####LEFT#####' => $left,
			'#####RIGHT#####' => $right,
			'#####AVG#####' => sprintf("%.2f",$avg)
		);	
		$radio=h_template_get_parsed_file($template_name."-table_row_bar", $replace);
		$table.="\n<tr>\n$title\n$radio\n</tr>";
		
	}
	$table.="\n";
	return $table;

}

function h_poll_banned_ip()
{
	global $__H_POLL_BANNED_IP;
	if(is_array($__H_POLL_BANNED_IP))
	{
		if(count($__H_POLL_BANNED_IP))
		{
			$sql_pre="";
			foreach ($__H_POLL_BANNED_IP as $key => $value)
			{
				if($sql_pre!="")
					$sql_pre .= " or ";
				//$sql.="'200.65.4.252'";
				$sql_pre.="(pll_coo_ip = '".$value['IP']."'";
				if(!empty($value['MIN'])&&!empty($value['MAX']))
					$sql_pre.="and pll_coo_date between '".$value['MIN']."' and '".$value['MAX']."'";
				$sql_pre.=")";
			}
			$sql=" and pll_vot_cookie not in (select pll_coo_cookie from h_poll_cookie where ($sql_pre))";
			return $sql;
		}
	}
}

function h_poll_show_results($id, $key, $span, $depend, $depend_det)
{
	global $H_PLL_RESULTS;
	if(!empty($H_PLL_RESULTS))
	{
		if(__H_POLL_SHOW_RESULTS)
			return 1;
		else
			return 0;
	}
	if(check_poll_depend($id, $key, $span, $depend, $depend_det))
	{
		if(__H_POLL_SHOW_RESULTS)
			return 1;
		else
			return 0;
	}
	return 0;
}

function check_poll_depend($id, $key, $span, $depend, $depend_det)
{
	if(!empty($depend))
	{
		$deppend_cookie=h_poll_get_cookie($depend);
		if(!empty($depend_det))
		{
			s_log("Check dependencies on poll $depend det $depend_det with cookie $deppend_cookie ");
			
			if(h_poll_used_cookie($id, $deppend_cookie, 0, $depend_det))
				return 1;
		}
	}
	return 0;
}

function set_poll_cookie()
{
	$__poll_db_id=hopp_db_connect();
	$galleta=h_poll_set_cookie($__poll_db_id, __H_POLL_KEY);
	#s_log("galleta: $galleta");
}

#------------------------------------------------------------------------------
} //__H_POLL_CORE__
?>
