<?
# poll-interface.inc Copyright (C) 2001-2002 Sandino Araico Snchez
/* --LICENSE IN US ENGLISH----------------------------------------------------- 
 * "THE BEER-WARE LICENSE" (Revision 42-sandino-3): 
 * Sandino Araico Snchez <sandino@sandino.net> wrote this file. 
 * As long as you retain this notice you can do whatever you want with this 
 * software. If we meet some day, and you think this stuff is worth it, you can 
 * buy me a beer in return. 
 * Sandino Araico Snchez 
 * --LICENCIA EN ESPAOL MEXICANO----------------------------------------------
 * "LA LICENCIA BEER-WARE" (traduccin al espaol de la revisin 42-sandino-3):
 * Sandino Araico Snchez <sandino@sandino.net> escribi ste archivo.
 * Siempre y cuando usted retenga ste aviso (en espaol y en ingls) usted
 * puede hacer cualquier cosa con ste software. Si algn da nos encontramos y 
 * usted piensa que ste software vale la pena, usted puede invitarme una 
 * cerveza en recompensa.
 * Sandino Araico Snchez
 * --FIN DE LICENCIA-----------------------------------------------------------
 */
 
# Changelog: 
# 2001-09-17 Sandino Araico Snchez <sandino@sandino.net>
#	Pegamento de polls de HOPP para Ascend
# 2001-09-25 Sandino Araico Snchez <sandino@sandino.net>
#	Desascendificacin de la librera
# 2001-10-01 Sandino Araico Snchez <sandino@sandino.net>
#	Fixed old cach bug
#	Independized votes submision process
#	Results
# 2001-10-03 Sandino Araico Snchez <sandino@sandino.net>
# 	h_poll_results()
# 2001-11-20 Sandino Araico Snchez <sandino@sandino.net>
# 	Fixed h_poll_submit_votes(), avoid multiple votes
# 2002-03-27 Sandino Araico Snchez <sandino@sandino.net>
# 	Renamed poll-glue to poll-interface
	/* 	poll-interface is no longer a glue. It containes the functions to be 
	 *	called from poll applications and poll glues so there's no need to 
	 *	call lower level functions from poll-core.
	 *	Functions' parameters and names in this file should be KISS.
	 */
	 // Perhaps poll-api is a better name, but, who cares?
# 2002-04-01 Sandino Araico Snchez <sandino@sandino.net>
#	more show/hide criteria	 

if(!defined("__H_POLL_INTERFACE"))
{
define("__H_POLL_INTERFACE",1);
#------------------------------------------------------------------------------
if(!defined('__H_POLL_SHOW_RESULTS'))
	define ('__H_POLL_SHOW_RESULTS',1);
include __HOPP_INCLUDE_PATH."poll/poll-core.inc";
#------------------------------------------------------------------------------
function h_poll($id=0, $template_name="poll")
{
	print h_poll_get_poll($id, $template_name);
}

function h_poll_results($id=0, $template_name="poll")
{
	$id=hopp_db_connected($id);
	print h_poll_get_results($id, $template_name);
}

function h_poll_get_poll($id=0, $template_name="poll")
{
	$id=hopp_db_connected($id);
	global $H_PLL_SUBMIT;
	#s_log("H_PLL_SUBMIT: $H_PLL_SUBMIT");
	if(!empty($H_PLL_SUBMIT))
		h_poll_submit_votes($id);
	$galleta=h_poll_set_cookie($id, __H_POLL_KEY);
	#s_log("galleta: $galleta");
	return h_poll_get_table($id, $galleta, $template_name);
}

function h_poll_submit_votes($id, $galleta='', $KEY=0, $SPAN=0)
{
	if(empty($KEY))
		$KEY=__H_POLL_KEY;
	if(empty($SPAN))	
		$SPAN=__H_POLL_SPAN;
	if(empty($galleta))
		$galleta=h_poll_get_cookie($KEY);

	$span=$KEY+$SPAN;
	$comment=h_poll_get_comment();
	hopp_db_start_transaction($id);
	if(!empty($comment))
		h_poll_put_comment($id, $galleta, $KEY, $comment);
	for($i=$KEY;$i<$span;$i++)
	{
		h_poll_put_votes($id, $galleta, $i);
	}
	hopp_db_end_transaction($id);
}

function h_poll_get_table($id, $galleta, $template_name="poll", $KEY=0, $SPAN=0, $form_submit=0)
{
	if(empty($KEY))
		$KEY=__H_POLL_KEY;
	if(empty($SPAN))
		$SPAN=__H_POLL_SPAN;
	#s_log("cookie: $galleta");
	if(h_poll_used_cookie($id, $galleta))
	{
		#s_log("Used cookie: $galleta");
		if($SPAN>1)
			return h_poll_get_processed_table($id, $galleta, $KEY, $SPAN, $template_name, $form_submit);
		else if (__H_POLL_SHOW_RESULTS)
			return h_poll_get_results($id, $template_name, $KEY, $SPAN, $form_submit);
		else
			return;
	}	
	else
		return h_poll_get_cached_table($id, $galleta, $template_name, $KEY, $SPAN, $form_submit);
}

function h_poll_get_comment_table($id, $replace, $template_name="poll", $KEY=0)
{
	if(!defined('__H_POLL_SHOW_SUBMIT'))	
		define('__H_POLL_SHOW_SUBMIT',1);
	if(empty($KEY))
		$KEY=__H_POLL_KEY;
	global $SERVER_NAME;
	if(empty($KEY))
		$KEY=__H_POLL_KEY;
	$doc_id_string="$SERVER_NAME:$template_name:POLL-COMMENT:$KEY";
	#s_log("doc_id_string: $doc_id_string");
	$doc_include=hopp_get_local_doc_array_from_cache($doc_id_string , __H_POLL_CACHE_TTL);
	if(empty($doc_include))
	{
		if(empty($replace))
		{
			global $SCRIPT_NAME;
			$replace=array(
				'#####SCRIPT_NAME#####' => $SCRIPT_NAME,
				'#####KEY#####' => "comment-$KEY"
			);	
		}
		$doc_include=h_template_get_parsed_file($template_name."-comment", $replace, 1);	
		$doc_put=hopp_put_local_doc_array_into_cache($doc_id_string, $doc_include);
	}
	return $doc_include;
}

function h_poll_get_results($id, $template_name, $KEY=0, $SPAN=0)
{
	global $SERVER_NAME;
	if(empty($KEY))
		$KEY=__H_POLL_KEY;
	if(empty($SPAN))	
		$SPAN=__H_POLL_SPAN;
	$doc_id_string="$SERVER_NAME:$template_name:POLL-RESULT:$KEY:$SPAN";
	##s_log("doc_id_string: $doc_id_string");
	$doc_include=hopp_get_local_doc_array_from_cache($doc_id_string , __H_POLL_RESULTS_CACHE_TTL);
	if(empty($doc_include))
	{
		$doc_include=h_poll_get_processed_results($id, $KEY, $SPAN, $template_name);
		$doc_put=hopp_put_local_doc_array_into_cache($doc_id_string, $doc_include);
	}
	return $doc_include;

}

function h_poll_get_comment_results($id, $replace, $template_name, $KEY)
{
	global $SERVER_NAME;
	if(empty($KEY))
		$KEY=__H_POLL_KEY;
	$doc_id_string="$SERVER_NAME:$template_name:POLL-RESULT-COMMENT:$KEY";
	s_log("doc_id_string: $doc_id_string");
	$doc_include=hopp_get_local_doc_array_from_cache($doc_id_string , __H_POLL_RESULTS_CACHE_TTL);
	if(empty($doc_include))
	{
		if(!is_array($replace))
		{
			global $SCRIPT_NAME;
			$replace=array(
				'#####SCRIPT_NAME#####' => $SCRIPT_NAME,
				'#####KEY#####' => "$KEY"
			);	
		}
		$doc_include=h_template_get_parsed_file($template_name."-comment_result", $replace, 1);	
		$doc_put=hopp_put_local_doc_array_into_cache($doc_id_string, $doc_include);
	}
	return $doc_include;

}

function h_poll_comments($id, $KEY, $template_name="poll")
{
	$sql="select pll_com_txt from h_poll_comment where pll_com_poll = $KEY";
	#s_log("sql: $sql");
	$res_pre=hopp_db_get_multi_row_array_result($id, $sql);
	if(!is_array($res_pre))
		return;
	$list='';
	foreach ($res_pre as $value)
	{
		#s_log ("value:".$value['pll_com_txt']);
		$replace=array('####ITEM#####' => $value['pll_com_txt']);
		$list.=h_template_get_parsed_file($template_name."-list_row", $replace, 1);
	}
	return $list;
}

#------------------------------------------------------------------------------
#------------------------------------------------------------------------------
} //__H_POLL_INTERFACE
?>
