<?
# s-log.inc
/* 
 * ---------------------------------------------------------------------------- 
 * "THE BEER-WARE LICENSE" (Revision 42-sandino-1): 
 * <sandino@sandino.net> wrote this file. As long as you retain this notice you 
 * can do whatever you want with this stuff. If we meet some day, and you think 
 * this stuff is worth it, you can buy me a beer in return. 
 * Sandino Araico Snchez 
 * ---------------------------------------------------------------------------- 
 * 
 */
 
# Changelog
# 2000-09-09 Sandino Araico Snchez - Simple Log Functions 
# 2001-01-10 Sandino Araico Snchez - Moved params here for use in stand-alone 
# 2001-02-09 Sandino Araico Snchez - Parametrizacin y uso de constantes
# 2001-02-09 Sandino Araico Snchez - Nuevas funciones
# 2001-02-21 Sandino Araico Snchez - Cambio de licencia
# 2001-10-02 Sandino Araico Snchez - Default de DEBUG y uso del valor 
# 2002-05-10 Sandino Araico Snchez - Loging level

if(!defined("__S__LOG"))
{
define ("__S__LOG",1);
#---------------------------------------------------------------------
//Parametros
if(!defined("__S__LOG_TYPE"))
	define("__S__LOG_TYPE",3);
if(!defined("__S__LOG_DEST"))	
	define("__S__LOG_DEST","/var/log/apache/s_log");

if(!defined("__DEBUG__"))
	define ("__DEBUG__",0);
#---------------------------------------------------------------------
if(__DEBUG__)
{
	function s_log($message, $file="", $line="", $level=0)
	{
		if(__DEBUG__>$level)
		{
			s_log_always($message, $file, $line);
		}	
	}
}
else
{
	function s_log() { }
}

function s_log_always($message, $file="", $line="")
{
	global $PHP_SELF;
	$message="[".basename($PHP_SELF).(($file || $line)?" ($file - $line)":"")."] $message";
	error_log("$message \n",__S__LOG_TYPE,__S__LOG_DEST);

}

function s_log_error($message, $file="", $line="")
{
	$message="\n======> [ERROR] <======\n$message\n======\n";
	s_log_always($message, $file, $line);
}

#---------------------------------------------------------------------
} //__S__LOG

?>
