<?
# Module: Template
# template-basic.inc Copyright (C) 2000-2002 Sandino Araico Snchez
/* --LICENSE IN US ENGLISH----------------------------------------------------- 
 * "THE BEER-WARE LICENSE" (Revision 42-sandino-3): 
 * Sandino Araico Snchez <sandino@sandino.net> wrote this file. 
 * As long as you retain this notice you can do whatever you want with this 
 * software. If we meet some day, and you think this stuff is worth it, you can 
 * buy me a beer in return. 
 * Sandino Araico Snchez 
 * --END LICENSE---------------------------------------------------------------
 * --LICENCIA EN ESPAOL MEXICANO----------------------------------------------
 * "LA LICENCIA BEER-WARE" (traduccin al espaol de la revisin 42-sandino-3):
 * Sandino Araico Snchez <sandino@sandino.net> escribi ste archivo.
 * Siempre y cuando usted retenga ste aviso (en espaol y en ingls) usted
 * puede hacer cualquier cosa con ste software. Si algn da nos encontramos y 
 * usted piensa que ste software vale la pena, usted puede invitarme una 
 * cerveza en recompensa.
 * Sandino Araico Snchez
 * --FIN DE LICENCIA-----------------------------------------------------------
 */
 
# Changelog: 
# 2000-10-13 Sandino Araico Snchez - Basic template functionality
# 2001-09-18 Sandino Araico Sanchez -  h_template_get_parsed_file() 
# 2001-10-02 Sandino Araico Sanchez -  h_template_get_file()
# 2001-11-09 Sandino Araico Sanchez - Cambio de prioridad de las extensiones de los templates
# 2002-03-27 Sandino Araico Sanchez - Some optimization on basic_template_container_probe_name()

if(!defined("__HOPP_TEMPLATE_BASIC"))
{
define ("__HOPP_TEMPLATE_BASIC",1);
#---------------------------------------------------------------------
include __HOPP_INCLUDE_PATH."s.inc";
#---------------------------------------------------------------------
function h_template_get_file($template_file, $probe=1, $persist=0)
{
	if($persist)
	{
		#s_log("Looking for persistent template file $template_file");
		$file=h_template_get_file_from_memory($template_file);
		if(!empty($file))
			return $file;
	}
	
	/* This language part should be removed.
	 * Instead, a directory-based language container should be created
	 */
	if($probe)
	{
		if(defined("__HOPP_TEMPLATE_DEF_LANG__"))
			$template_file.=".".__HOPP_TEMPLATE_DEF_LANG__;
	}		
	#s_log("Trying to include template from $template_file");
	// If the template does not exist we should look for it
	if(file_exists($template_file))
	{
		#s_log("Including template from $template_file");
		$file=fopen($template_file, "r");
		$file_content=fread($file,1048576); // Read up to 1M
		fclose($file);
	}
	else
	{
		if($probe)
		{
			$probed_name=basic_template_container_probe_name($template_file);
			$file_content=h_template_get_file($probed_name, 0, $persist);
			
		}
	}	
	if(empty($file_content))
		return;
	if($persist)
		h_template_put_file_into_memory($template_file, $file_content);
	return $file_content;
}

function h_template_get_parsed_file($template_file, $array, $probe=1, $persist=0)
{
	if(empty($template_file))
		return;


	$file=h_template_get_file($template_file, $probe, $persist);

	if(is_array($array))
	{
		foreach($array as $key => $value)
		{
			#s_log("Replacing $key with $value");
			$file=str_replace($key, $value, $file);
		}
	}
	return $file;
}

function h_template_get_file_from_memory($template_file)
{
	global $__HOPP_TEMPLATE_MEMORY_CACHE__;
	if(is_array($__HOPP_TEMPLATE_MEMORY_CACHE__))
	{
		#s_log("Looking for file $template_file in memory");
		if(!empty($__HOPP_TEMPLATE_MEMORY_CACHE__[$template_file]))
		{
			#s_log("File $template_file found in memory");
			return $__HOPP_TEMPLATE_MEMORY_CACHE__[$template_file];
		}	
	}
}

function h_template_put_file_into_memory($template_file, $file)
{
	#s_log("Storing persistent template file $template_file");
	global $__HOPP_TEMPLATE_MEMORY_CACHE__;
	$__HOPP_TEMPLATE_MEMORY_CACHE__[$template_file]=$file;
}

function basic_template_container_hardcoded($template, $theme="", $subtheme="")
{
	return basic_template_container_general(0,0, $template, "H", 0, $theme, $subtheme);
}

function basic_template_container_with_variables($template, $array, $theme="", $subtheme="")
{
	return basic_template_container_general(0,0, $template, "V", $array, $theme, $subtheme);
}

/* 2000-10-17 Sandino Araico Snchez
 * This function is ready to expand variables contained in the array $data
 * in the inclusion of the template.
 * It is possible to expand a functon but I don't want to mess with function names.
 * Perhaps a variable-expand to function-expand template translator is possible
 * but it's not the purpose of this function and should be done in a separate one.
 */
function basic_template_container_general($id, $use_id, $template_file, $expand, $data, $theme, $subtheme, $probe=1)
{
	if(empty($template_file))
		return;
	#s_log("Trying to include template from $template_file");
	// If the template does not exist we should look for it
	if(!file_exists($template_file))
		return ($probe?basic_template_container_general($id, $use_id, basic_template_container_probe_name($template_file, $theme, $subtheme), $expand, $data, $theme, $subtheme,0):"");
	#s_log("Including template from $template_file");
	switch($expand)
	{
	case "F":
	case "V":
		/* We are using a macro here
		 * Care should be taken that macros are executable on include
		 * Notice that we use include instead of require 
		 */ 
		$__HOPP_VARIABLES_ARRAY__=$data;
		include "include/MACRO/extract_variables_from_array.inc";	
	default:
		return $template_file;
	}
}

function basic_template_container_probe_name($name, $theme="", $subtheme="", $recurse=1)
{
	#s_log("probing $name, theme: $theme, subtheme: $subtheme, recurse: $recurse");
	if(empty($name))
		return;
	if(file_exists($name))
		return $name;
	if($theme)
	{
		if($subtheme)
		{
			$i=basic_template_container_probe_name("$theme/$subtheme/$name","","",$recurse);
			if($i)
				return $i;
			$i=basic_template_container_probe_name("$theme/$name_$subtheme","","",$recurse);	
			if($i)
				return $i;
			$i=basic_template_container_probe_name("$theme/$name.$subtheme","","",$recurse);	
			if($i)	
				return $i;
		}		
		$i=basic_template_container_probe_name("$theme/$name","","",$recurse);
		if($i)	
			return $i;
	}		
	if(!strstr($name, __HOPP_TEMPLATE_DIR__))
	{
		$i=basic_template_container_probe_name(__HOPP_TEMPLATE_DIR__."$name","","",$recurse);
		if($i)	
			return $i;
	}	
	if(!ereg("(\.php$)|(\.inc$)|(\.html$)", $name))	
	{
		$i=basic_template_container_probe_name("$name.html","","",$recurse);
		if($i)	
			return $i;
		$i=basic_template_container_probe_name("$name.inc","","",$recurse);
		if($i)	
			return $i;
		$i=basic_template_container_probe_name("$name.php","","",$recurse);
		if($i)	
			return $i;
	}
	
	if($recurse)
	{
		global $__HOPP_THEME__;
		if($__HOPP_THEME__)
		{
			$i=basic_template_container_probe_name($name, $__HOPP_THEME__, $subtheme, 0);
			if($i)	
				return $i;
		}	
		// FIXME - "default" seems not to be working as expected.....
		/*$i=basic_template_container_probe_name($name, "default", $subtheme, 0);
		if($i)	
			return $i;*/
	}
	if(!defined('__HOPP_TEMPLATE_DIR__')&&!ereg("^hopp/template/", $name))
	{
		if(!ereg("^template/", $name))
		{
			$i=basic_template_container_probe_name("template/$name","","",$recurse);
			if($i)	
				return $i;
		}
		else
		{
			$i=basic_template_container_probe_name("hopp/$name","","",$recurse);
			if($i)	
				return $i;
		}
	}
	#s_log("probing $name unsuccessful");
}
#---------------------------------------------------------------------
} //__HOPP_TEMPLATE_BASIC
?>
