<?
# Module: Template
# template-elements.inc Copyright (C) 2000-2001 Sandino Araico Snchez
/* --LICENSE IN US ENGLISH----------------------------------------------------- 
 * "THE BEER-WARE LICENSE" (Revision 42-sandino-3): 
 * Sandino Araico Snchez <sandino@sandino.net> wrote this file. 
 * As long as you retain this notice you can do whatever you want with this 
 * software. If we meet some day, and you think this stuff is worth it, you can 
 * buy me a beer in return. 
 * Sandino Araico Snchez 
 * --END LICENSE---------------------------------------------------------------
 * --LICENCIA EN ESPAOL MEXICANO----------------------------------------------
 * "LA LICENCIA BEER-WARE" (traduccin al espaol de la revisin 42-sandino-3):
 * Sandino Araico Snchez <sandino@sandino.net> escribi ste archivo.
 * Siempre y cuando usted retenga ste aviso (en espaol y en ingls) usted
 * puede hacer cualquier cosa con ste software. Si algn da nos encontramos y 
 * usted piensa que ste software vale la pena, usted puede invitarme una 
 * cerveza en recompensa.
 * Sandino Araico Snchez
 * --FIN DE LICENCIA-----------------------------------------------------------
 */
 
# Changelog: 
# 2000-10-18 Sandino Araico Snchez - Per-element template functions
if(!defined("__HOPP_TEMPLATE_ELEMENTS"))
{
define ("__HOPP_TEMPLATE_ELEMENTS",1);
#---------------------------------------------------------------------
include __HOPP_INCLUDE_PATH."s.inc";
#---------------------------------------------------------------------
function hopp_element_main_page($title, $variables_array="")
{
	if(!is_array($variables_array))
	{
		$variables_array=array(
			"__HOPP_PAGE_TITLE__" => $title,
			"__HOPP_BODY_FUNCTION__" => "hopp_element_body",
			"__HOPP_HEAD_FUNCTION__" => "hopp_element_head"
		);
	}
	basic_template_container_with_variables("main", $variables_array);

}

function hopp_element_body( $variables_array="")
{
	if(!is_array($variables_array))
	{
		$variables_array=array(
			"__HOPP_INSIDE_BODY_FUNCTION__" => "hopp_body_handler"
		);
	}
	basic_template_container_with_variables("body", $variables_array);
}

function hopp_element_head($variables_array="")
{
	if(!is_array($variables_array))
	{
		$variables_array=array(
			"__HOPP_INSIDE_HEAD_FUNCTION__" => "hopp_head_handler"
		);
	}
	basic_template_container_with_variables("head", $variables_array);
}

function hopp_element_generic_text($var_name, $template_name, $text, $htmlize=0)
{
	if($htmlize)
		$text=nl2br(htmlentities(stripslashes($text)));
	$variables_array=array(
		$var_name	 => $text
	);
	basic_template_container_with_variables($template_name, $variables_array);
}

function hopp_element_title_text($text, $htmlize=0)
{
	hopp_element_generic_text("__HOPP_TITLE_CONTENT__", "title", $text, $htmlize);
}

function hopp_element_subtitle_text($text, $htmlize=0)
{
	hopp_element_generic_text("__HOPP_SUBTITLE_CONTENT__", "subtitle", $text, $htmlize);
}

function hopp_element_paragraph_text($text, $htmlize=0)
{
	hopp_element_generic_text("__HOPP_PARAGRAPH_CONTENT__", "paragraph", $text, $htmlize);
}

function hopp_element_subtitle_include($filename, $htmlize=0)
{
	hopp_element_subtitle_text(hopp_element_get_corrected_filename_text($filename), $htmlize);
}

function hopp_element_get_corrected_filename_text($filename)
{
	$filename_corrected=basic_template_container_probe_name($filename);
	s_log("filename_corrected: $filename_corrected");
	if($filename_corrected)
	{
		$fd = fopen ($filename_corrected, "r");
		$file_content = fread ($fd, filesize ($filename_corrected));
		fclose ($fd);
	}	
	return $file_content;
}
#---------------------------------------------------------------------
} //__HOPP_TEMPLATE_ELEMENTS
?>
